<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmailTemplatesTable extends Migration {

	public function up()
	{
		Schema::create('email_templates', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('body_html');
			$table->enum('recipient_type', array('user', 'admin'));
			$table->boolean('is_active')->default(true);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('email_templates');
	}
}