<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('slug');
			$table->longText('content');
			$table->enum('post_type', array('post', 'page'))->nullable();
			$table->string('meta_page_title');
			$table->string('meta_description')->nullable();
			$table->string('featured_image')->nullable();
			$table->enum('status', array('publish', 'unpublish', 'archive'));
			$table->boolean('allow_comments')->default(true);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}