<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('site_name');
			$table->string('site_url');
			$table->string('site_email');
			$table->string('default_currency');
			$table->string('default_storage')->nullable();
			$table->string('default_language')->nullable();
			$table->boolean('allow_comments')->default(true);
			$table->boolean('is_privacy_active')->default(true);
			$table->boolean('show_privacy_on_login')->default(true);
			$table->longText('privacy_policy')->nullable();
			$table->longText('terms_conditions')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}