<?php

namespace App\Models;

class Ticket extends Eloquent {

	protected $table = 'tickets';
	public $timestamps = true;

	public function category()
	{
		return $this->belongsTo('TicketCategory');
	}

	public function comments()
	{
		return $this->hasMany('TicketReply');
	}

	public function attachments()
	{
		return $this->hasMany('Attachment', 'model_id');
	}

	public function priorities()
	{
		return $this->hasMany('TicketPriority');
	}

}