<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAffiliateCommissionsTable extends Migration {

	public function up()
	{
		Schema::create('affiliate_commissions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('affiliate_id')->unsigned();
			$table->bigInteger('subscription_id')->unsigned();
			$table->double('amount');
			$table->timestamp('available_at')->nullable();
			$table->timestamp('paid_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('affiliate_commissions');
	}
}