<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCollaborateursTable extends Migration {

	public function up()
	{
		Schema::create('collaborateurs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('prenom', 30);
			$table->string('nom', 30);
			$table->string('initiales', 4);
			$table->string('email', 255);
			$table->date('date_arrivee');
			$table->date('date_depart');
			$table->smallInteger('salaire')->unsigned();
			$table->decimal('taux_facturable', 2,4);
			$table->string('infos', 255);
			$table->integer('type_collaborateur_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('collaborateurs');
	}
}