<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEvenementsTable extends Migration {

	public function up()
	{
		Schema::create('evenements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->datetime('debut');
			$table->datetime('fin');
			$table->smallInteger('duree')->unsigned();
			$table->boolean('is_css');
			$table->boolean('is_cp');
			$table->boolean('is_cm');
			$table->string('infos', 255);
			$table->integer('collaborateur_id')->unsigned();
			$table->integer('phase_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('evenements');
	}
}