<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePhasesTable extends Migration {

	public function up()
	{
		Schema::create('phases', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('date_prevue');
			$table->boolean('is_terminee');
			$table->boolean('is_option');
			$table->boolean('is_facturable');
			$table->boolean('is_avenant');
			$table->string('infos', 255);
			$table->integer('projet_id')->unsigned();
			$table->integer('type_phase_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('phases');
	}
}