<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 64);
			$table->string('last_name', 64);
			$table->string('email', 128);
			$table->string('website', 128)->nullable();
			$table->string('city', 1228)->nullable();
			$table->integer('state_id')->unsigned()->nullable();
			$table->string('zip', 12)->nullable();
			$table->string('remember_token', 100)->nullable();
			$table->string('password', 60)->nullable();
			$table->string('api_key', 100)->nullable();
			$table->string('display_name')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}