<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tours', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tours', function(Blueprint $table) {
			$table->foreign('thumbnail_id')->references('id')->on('mediaresources')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tourstops', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tourstops', function(Blueprint $table) {
			$table->foreign('thumbnail_id')->references('id')->on('mediaresources')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tourlists', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mediaresources', function(Blueprint $table) {
			$table->foreign('mediatype_id')->references('id')->on('mediatypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('useractivities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('userfollows', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('userfollows', function(Blueprint $table) {
			$table->foreign('followed_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tours', function(Blueprint $table) {
			$table->dropForeign('tours_author_id_foreign');
		});
		Schema::table('tours', function(Blueprint $table) {
			$table->dropForeign('tours_thumbnail_id_foreign');
		});
		Schema::table('tourstops', function(Blueprint $table) {
			$table->dropForeign('tourstops_state_id_foreign');
		});
		Schema::table('tourstops', function(Blueprint $table) {
			$table->dropForeign('tourstops_thumbnail_id_foreign');
		});
		Schema::table('tourlists', function(Blueprint $table) {
			$table->dropForeign('tourlists_author_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_state_id_foreign');
		});
		Schema::table('mediaresources', function(Blueprint $table) {
			$table->dropForeign('mediaresources_mediatype_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('useractivities', function(Blueprint $table) {
			$table->dropForeign('useractivities_user_id_foreign');
		});
		Schema::table('userfollows', function(Blueprint $table) {
			$table->dropForeign('userfollows_user_id_foreign');
		});
		Schema::table('userfollows', function(Blueprint $table) {
			$table->dropForeign('userfollows_followed_user_id_foreign');
		});
	}
}