<?php

namespace App;

class LSD_Tour extends Eloquent {

	protected $table = 'tours';
	public $timestamps = true;
	protected $fillable = array('title', 'author_id', 'short_description', 'description', 'thumbnail_id', 'timerange_hours');

	public function tourstops()
	{
		return $this->hasMany('LSD_Tourstop')->withPivot('order');
	}

	public function tourlists()
	{
		return $this->belongsToMany('LSD_Tourlist')->withPivot('order');
	}

	public function comments()
	{
		return $this->hasMany('LSD_Comment');
	}

	public function thumbnail()
	{
		return $this->hasOne('LSD_Mediaresource');
	}

	public function tags()
	{
		return $this->morphToMany('App\Tag', 'taggable');
	}

	public function favorors()
	{
		return $this->morphToMany('App\User', 'favoritable');
	}

}