<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class LSD_User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('first_name', 'last_name', 'email', 'website', 'city', 'state_id', 'zip', 'remember_token', 'password', 'api_key', 'display_name');

    public function follows()
    {
        return $this->belongsToMany('App\LSD_User', 'userfollows', 'user_id', 'followed_user_id');
    }

    public function tours()
    {
        return $this->hasMany('App\LSD_Tour');
    }

    public function tourlists()
    {
        return $this->hasMany('App\LSD_Tourlist');
    }

    public function comments()
    {
        return $this->hasMany('App\LSD_Comment', 'user_id');
    }

    public function activities()
    {
        return $this->hasMany('App\LSD_Useractivity', 'user_id');
    }

    public function thumbnail()
    {
        return $this->hasOne('App\LSD_Mediaresource');
    }

    public function followers()
    {
        return $this->belongsToMany('App\LSD_User', 'userfollows', 'followed_user_id', 'user_id');
    }

    public function tags()
    {
        return $this->morphToMany('App\Tag', 'taggable');
    }

    public function favoriteTours()
    {
        return $this->morphedByMany('App\Tour', 'favoritable', 'favoritables', 'user_id', 'favoritable_id');
    }

    public function favoriteTourstops()
    {
        return $this->morphedByMany('App\Tourstop', 'favoritable', 'favoritables', 'user_id', 'favoritable_id');
    }

    public function favoriteTourlists()
    {
        return $this->morphedByMany('App\Tourlist', 'favoritable', 'favoritables', 'user_id', 'favoritable_id');
    }

}