<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('ch_room_mappings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ch_room_mappings', function(Blueprint $table) {
			$table->foreign('ch_room_id')->references('id')->on('ch_room')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ch_messages', function(Blueprint $table) {
			$table->foreign('ch_room_id')->references('id')->on('ch_room')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ch_messages', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ch_attachments', function(Blueprint $table) {
			$table->foreign('ch_message_id')->references('id')->on('ch_messages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('ch_room_mappings', function(Blueprint $table) {
			$table->dropForeign('ch_room_mappings_user_id_foreign');
		});
		Schema::table('ch_room_mappings', function(Blueprint $table) {
			$table->dropForeign('ch_room_mappings_ch_room_id_foreign');
		});
		Schema::table('ch_messages', function(Blueprint $table) {
			$table->dropForeign('ch_messages_ch_room_id_foreign');
		});
		Schema::table('ch_messages', function(Blueprint $table) {
			$table->dropForeign('ch_messages_created_by_foreign');
		});
		Schema::table('ch_attachments', function(Blueprint $table) {
			$table->dropForeign('ch_attachments_ch_message_id_foreign');
		});
	}
}