<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('slug');
			$table->string('email')->nullable();
			$table->string('logo');
			$table->string('sponsorship_branding');
			$table->string('preview_logo');
			$table->string('prestream_display');
			$table->string('offline_image');
			$table->string('primary_colour');
			$table->string('secondary_colour');
			$table->string('override_actors_label');
			$table->string('override_places_label');
			$table->string('override_acts_label');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}