<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActAssignedDataTable extends Migration {

	public function up()
	{
		Schema::create('act_assigned_data', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('act_id')->unsigned();
			$table->string('streamable_type')->nullable();
			$table->integer('streamable_id');
			$table->string('assignable_type')->nullable();
			$table->integer('assignable_id');
			$table->smallInteger('sort_order')->nullable();
			$table->string('vod_url')->nullable();
			$table->text('aws_medialive_channel_id')->nullable();
			$table->integer('customer_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('act_assigned_data');
	}
}