<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEquipmentTable extends Migration {

	public function up()
	{
		Schema::create('equipment', function(Blueprint $table) {
			$table->increments('id_equipment');
			$table->integer('id_masterEquipment_foreign_key')->unsigned()->nullable();
			$table->integer('id_wirelessEquipment_foreign_key')->unsigned()->nullable();
			$table->integer('id_module_foreign_key')->unsigned()->nullable();
			$table->integer('id_slaveEquipment_foreign_key')->unsigned()->nullable();
			$table->string('equipmentType');
			$table->string('baseMacAddress')->nullable();
			$table->string('baseSoftwareVersion')->nullable();
			$table->string('baseSerialNumber')->nullable();
			$table->string('baseName')->nullable();
			$table->string('lastKnownUpAt')->nullable();
			$table->string('sysUpTime')->nullable();
			$table->string('chassisAdminStatus')->nullable();
			$table->string('chassisOperationalStatus')->nullable();
			$table->string('baseModel')->nullable();
			$table->string('macAddress')->nullable();
			$table->string('serialNumber')->nullable();
			$table->string('physicalName')->nullable();
			$table->string('ubootVersion')->nullable();
			$table->string('index')->nullable();
			$table->string('hardwareVersion')->nullable();
			$table->string('model')->nullable();
			$table->string('firmwareVersion')->nullable();
			$table->string('softwareVersion')->nullable();
			$table->string('slotName')->nullable();
			$table->string('physicalContainedIn')->nullable();
			$table->string('type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('equipment');
	}
}