<?php

namespace App\Models;

class Equipment extends Eloquent {

	protected $table = 'equipment';
	public $timestamps = false;
	protected $fillable = array('equipmentType', 'baseMacAddress', 'baseSoftwareVersion', 'baseSerialNumber', 'baseName', 'lastKnownUpAt', 'sysUpTime', 'chassisAdminStatus', 'chassisOperationalStatus', 'baseModel', 'macAddress', 'serialNumber', 'physicalName', 'ubootVersion', 'index', 'hardwareVersion', 'model', 'firmwareVersion', 'softwareVersion', 'slotName', 'physicalContainedIn', 'type');

	public function licenses()
	{
		return $this->hasMany('App\Models\EquipmentLicense', 'id_equipment_foreign_key');
	}

	public function modules()
	{
		return $this->hasMany('App\Models\ModuleEquipment', 'id_equipment_foreign_key');
	}

}