<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderItems extends Eloquent {

	protected $table = 'order_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'name', 'hsn', 'quantity');
	protected $visible = array('order_id', 'name', 'hsn', 'quantity');

	public function unit()
	{
		return $this->belongsTo('Unit', 'unit_id', 'id');
	}

}