<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('Services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('providor_id')->unsigned()->index();
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('category_id')->unsigned();
			$table->enum('service_type', array('normal_service', 'occasion_service'))->nullable();
			$table->string('name', 255)->nullable();
			$table->text('desc')->nullable();
			$table->double('longitude')->nullable()->default('0');
			$table->string('address', 255)->nullable();
			$table->double('price')->nullable()->default('0');
			$table->double('first_paid_price')->nullable()->default('0');
			$table->enum('with_offer', array('yes', 'no'))->nullable();
			$table->enum('offer_type', array('value', 'per'))->nullable();
			$table->timestamp('offer_start_from')->nullable();
			$table->timestamp('offer_end_from')->nullable();
			$table->text('terms_and_conditions')->nullable();
			$table->string('main_image', 191)->nullable();
			$table->string('whats_up_number', 191)->nullable();
			$table->string('facebook_link', 255)->nullable();
			$table->enum('facebook_is_shown', array('yes', 'no'))->nullable();
			$table->string('twitter_link', 255)->nullable();
			$table->string('twitter_is_shown', 255)->nullable();
			$table->string('snap_link', 255)->nullable();
			$table->enum('snap_is_shown', array('yes', 'no'))->nullable();
			$table->string('instegram_link', 255)->nullable();
			$table->enum('instegram_is_shown', array('yes', 'no'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Services');
	}
}