<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone_code', 191)->default('+966');
			$table->string('phone', 191)->nullable();
			$table->enum('user_type', array('normal_user', 'providor'))->nullable();
			$table->string('logo', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}