<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBugsTable extends Migration {

	public function up()
	{
		Schema::create('bugs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->longText('description');
			$table->enum('priority', array('Normal', 'High', 'Low', 'Highest'));
			$table->string('comment');
			$table->enum('status', array('Open', 'Inprogress', 'Resolved', 'Reopen', 'Rejected', 'ClosedAsDesigned', 'ClosedAsRejected'));
			$table->integer('created_by')->unsigned();
			$table->integer('assigned_to')->unsigned();
			$table->integer('task_id')->unsigned();
			$table->integer('component_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bugs');
	}
}