<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonalAccessTokensTable extends Migration {

	public function up()
	{
		Schema::create('personal_access_tokens', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->morphs('tokenable');
			$table->string('name');
			$table->string('token', 64);
			$table->text('abilities')->nullable();
			$table->timestamp('last_used_at')->nullable();
			$table->timestamp('expires_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('personal_access_tokens');
	}
}