<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCertificationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('user_certification_requests', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('file', 150);
			$table->bigInteger('category_id')->unsigned();
			$table->string('fist_url', 150);
			$table->string('second_url', 150);
			$table->boolean('in_progress')->default(0);
			$table->text('additional_information')->nullable();
			$table->boolean('is_accepted')->default(0);
			$table->boolean('is_refused')->default(0);
			$table->text('reason_for_refusal')->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_certification_requests');
	}
}