<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserInformationsTable extends Migration {

	public function up()
	{
		Schema::create('user_informations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('first_name', 50)->nullable();
			$table->string('last_name', 50)->nullable();
			$table->string('cover', 150)->nullable();
			$table->string('avatar', 150)->nullable();
			$table->text('biography')->nullable();
			$table->bigInteger('category_id')->unsigned()->nullable();
			$table->string('mobile', 50)->unique()->nullable();
			$table->date('birthday')->nullable();
			$table->string('country', 50)->nullable();
			$table->boolean('association_refund')->nullable()->default(0);
			$table->string('association_name', 50)->nullable();
			$table->string('association_url', 150)->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_informations');
	}
}