<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLiveInvitationsTable extends Migration {

	public function up()
	{
		Schema::create('live_invitations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('status')->default('waiting, payed, cancel');
			$table->boolean('is_vip')->default(0);
			$table->boolean('is_send')->default(0);
			$table->boolean('is_accept')->default(0);
			$table->datetime('date_of_acceptance')->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('live_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('live_invitations');
	}
}