<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('legal_case_after_settlement', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('legal_case_service_requests', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_case_after_settlement')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('legal_case_service_plans', function(Blueprint $table) {
			$table->foreign('legal_case_service_request_id')->references('id')->on('legal_case_service_requests')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('legal_case_service_plans', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('param_providers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('legal_case_service_plans', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('param_providers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('plan_attachments', function(Blueprint $table) {
			$table->foreign('legal_case_service_plan_id')->references('id')->on('legal_case_service_plans')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('legal_case_after_settlement', function(Blueprint $table) {
			$table->dropForeign('legal_case_after_settlement_legal_case_id_foreign');
		});
		Schema::table('legal_case_service_requests', function(Blueprint $table) {
			$table->dropForeign('legal_case_service_requests_legal_case_id_foreign');
		});
		Schema::table('legal_case_service_plans', function(Blueprint $table) {
			$table->dropForeign('legal_case_service_plans_legal_case_service_request_id_foreign');
		});
		Schema::table('legal_case_service_plans', function(Blueprint $table) {
			$table->dropForeign('legal_case_service_plans_provider_id_foreign');
		});
		Schema::table('legal_case_service_plans', function(Blueprint $table) {
			$table->dropForeign('legal_case_service_plans_bank_id_foreign');
		});
		Schema::table('plan_attachments', function(Blueprint $table) {
			$table->dropForeign('plan_attachments_legal_case_service_plan_id_foreign');
		});
	}
}