<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalCaseServiceRequestsTable extends Migration {

	public function up()
	{
		Schema::create('legal_case_service_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('legal_case_id')->unsigned();
			$table->string('ref_number');
			$table->bigInteger('request_user_id')->unsigned();
			$table->bigInteger('request_role_id')->unsigned();
			$table->bigInteger('assignee_user_id')->unsigned();
			$table->bigInteger('assignee_role_id')->unsigned();
			$table->datetime('assigned_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('legal_case_service_requests');
	}
}