<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LegalCaseServicePlans extends Model 
{

    protected $table = 'legal_case_service_plans';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('legal_case_service_request_id', 'service_type', 'rating', 'rating_note', 'assignee_user_id', 'assignee_role_id', 'assigned_at', 'provider_id', 'bank_id', 'request_note', 'manager_note', 'client_note', 'plan_name', 'bank_account_number', 'price', 'is_additional_file_needed', 'installation_date', 'is_request_price', 'is_terminated', 'terminated_at', 'termination_note');
    protected $visible = array('legal_case_service_request_id', 'service_type', 'rating', 'rating_note', 'assignee_user_id', 'assignee_role_id', 'assigned_at', 'provider_id', 'bank_id', 'request_note', 'manager_note', 'client_note', 'plan_name', 'bank_account_number', 'price', 'is_additional_file_needed', 'installation_date', 'is_request_price', 'is_terminated', 'terminated_at', 'termination_note');

    public function serviceRequest()
    {
        return $this->belongsTo('LegalCaseServiceRequests', 'legal_case_service_request_id');
    }

    public function provider()
    {
        return $this->belongsTo('ParamProvider', 'provider_id');
    }

    public function bank()
    {
        return $this->belongsTo('ParamProvider', 'bank_id');
    }

    public function attachments()
    {
        return $this->hasMany('PlanAttachments', 'legal_case_service_plan_id');
    }

}