<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('plan_attachments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('legal_case_service_plan_id')->unsigned();
			$table->string('original_name')->nullable();
			$table->string('system_name')->nullable();
			$table->string('file_path')->nullable();
			$table->timestamps();
			$table->enum('document_type', array('recommendation_plan', 'plan_contract', 'additional_file', 'payment_receipt'));
		});
	}

	public function down()
	{
		Schema::drop('plan_attachments');
	}
}