<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 30)->nullable();
			$table->string('slug', 30)->nullable();
			$table->tinyInteger('status')->nullable();
			$table->integer('event_id')->unsigned();
			$table->string('amount', 500)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}