<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminUserTable extends Migration {

	public function up()
	{
		Schema::create('admin_user', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 30)->nullable();
			$table->string('email', 500)->unique()->nullable();
			$table->string('mobile', 30)->unique()->nullable();
			$table->string('password', 500)->nullable();
			$table->smallInteger('status')->nullable();
			$table->bigInteger('role_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('admin_user');
	}
}