<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentReportTable extends Migration {

	public function up()
	{
		Schema::create('payment_report', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('purchase_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->tinyInteger('status')->nullable();
			$table->date('purchase_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payment_report');
	}
}