<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProcessTable extends Migration {

	public function up()
	{
		Schema::create('process', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('driver')->unsigned();
			$table->integer('passenger')->unsigned();
			$table->string('status');
			$table->integer('current_location')->unsigned();
			$table->string('start_location');
			$table->string('end_location');
			$table->string('last_location');
			$table->string('expected_payment');
			$table->string('real_payment');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('process');
	}
}