<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('drivers', function(Blueprint $table) {
			$table->foreign('car')->references('id')->on('cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('process', function(Blueprint $table) {
			$table->foreign('driver')->references('id')->on('drivers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('process', function(Blueprint $table) {
			$table->foreign('passenger')->references('id')->on('passengers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('process', function(Blueprint $table) {
			$table->foreign('current_location')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('drivers', function(Blueprint $table) {
			$table->dropForeign('drivers_car_foreign');
		});
		Schema::table('process', function(Blueprint $table) {
			$table->dropForeign('process_driver_foreign');
		});
		Schema::table('process', function(Blueprint $table) {
			$table->dropForeign('process_passenger_foreign');
		});
		Schema::table('process', function(Blueprint $table) {
			$table->dropForeign('process_current_location_foreign');
		});
	}
}