<?php

namespace App;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('product_name', 'car_model_id', 'model_type_id', 'year', 'main_image', 'notes', 'product_status');

	public function productInnerCars()
	{
		return $this->hasMany('App\InnerCar');
	}

	public function notification()
	{
		return $this->morphMany('App\Notification', 'notifiable');
	}

}