<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Comprobante extends Model 
{

    protected $table = 'comprobantes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function documento()
    {
        return $this->belongsToMany('Documento', 'id');
    }

    public function sede()
    {
        return $this->belongsToMany('Sede', 'id');
    }

    public function tercero()
    {
        return $this->belongsToMany('Tercero', 'id');
    }

}