<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTercerosTable extends Migration {

	public function up()
	{
		Schema::create('terceros', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('tipo_identificacion_id')->unsigned();
			$table->string('numero_identificacion');
			$table->string('nombre_completo');
			$table->string('primer_nombre');
			$table->string('segundo_nombre');
			$table->string('primer_apellido');
			$table->string('segundo_apellido');
			$table->enum('persona', array('natural', 'juridica'));
			$table->integer('genero')->unsigned();
			$table->datetime('fecha_nacimiento');
			$table->string('email');
			$table->string('celular');
			$table->string('telefono');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('terceros');
	}
}