<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Course', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('Category')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('Enrolled_course', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Enrolled_course', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('Course')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Lessons', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('Course')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Course', function(Blueprint $table) {
			$table->dropForeign('Course_category_id_foreign');
		});
		Schema::table('Enrolled_course', function(Blueprint $table) {
			$table->dropForeign('Enrolled_course_user_id_foreign');
		});
		Schema::table('Enrolled_course', function(Blueprint $table) {
			$table->dropForeign('Enrolled_course_course_id_foreign');
		});
		Schema::table('Lessons', function(Blueprint $table) {
			$table->dropForeign('Lessons_course_id_foreign');
		});
	}
}