<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('Name', 255);
			$table->string('email', 255);
			$table->timestamps();
			$table->string('remember_token', 100)->nullable();
			$table->string('password', 255);
			$table->timestamp('created_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}