<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('department_id')->unsigned()->nullable();
			$table->bigInteger('role_id')->unsigned()->nullable();
			$table->string('firstName', 100);
			$table->string('middleName', 100)->nullable();
			$table->string('lastName', 100);
			$table->string('email', 255);
			$table->string('password', 255);
			$table->string('phoneNumber', 100);
			$table->string('lastLogin', 255);
			$table->smallInteger('status')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}