<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('category_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned()->default('null');
			$table->string('name')->nullable()->default('null');
			$table->string('slug')->nullable()->default('null');
			$table->string('description')->nullable()->default('null');
			$table->string('locale')->index();
		});
	}

	public function down()
	{
		Schema::drop('category_translations');
	}
}