<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParameterItemTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('parameter_item_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parameter_item_id')->unsigned()->default('null');
			$table->string('name')->nullable()->default('null');
			$table->string('slug')->nullable()->default('null');
			$table->string('description')->nullable()->default('null');
			$table->string('locale')->index();
		});
	}

	public function down()
	{
		Schema::drop('parameter_item_translations');
	}
}