<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function parameters()
	{
		return $this->hasMany('App\Parameter');
	}

	public function translations()
	{
		return $this->hasMany('App\CategoryTranslation');
	}

}