<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->default('false');
			$table->string('avater', 255);
			$table->string('email', 50)->unique();
			$table->string('password', 255);
			$table->string('phone', 50)->unique();
			$table->boolean('is_active')->default(0);
			$table->boolean('is_block')->default(0);
			$table->decimal('wallet_balance')->default('0');
			$table->timestamps();
			$table->boolean('is_delegate')->default(0);
			$table->string('delegate_id', 50)->unique()->default('null');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}