<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerchantsTable extends Migration {

	public function up()
	{
		Schema::create('merchants', function(Blueprint $table) {
			$table->uuid('id');
			$table->string('first_name', 50);
			$table->string('last_name', 100);
			$table->string('email', 100)->unique();
			$table->string('phone', 10)->unique();
			$table->integer('status')->default('0');
			$table->string('password');
			$table->string('company_name', 100)->nullable();
			$table->text('business_link')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('merchants');
	}
}