<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user_has_many_qoutes()
    {
        return $this->hasMany('Quote_Request');
    }

    public function orders()
    {
        return $this->hasMany('Order');
    }

    public function Inbound_Shipements()
    {
        return $this->hasMany('Inbound_Shipments');
    }

    public function Support_Tickets()
    {
        return $this->hasMany('Support_Tickets');
    }

    public function merchant()
    {
        return $this->belongsTo('Merchant', 'merchent_id');
    }

}