<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupportTicketsTable extends Migration {

	public function up()
	{
		Schema::create('support_tickets', function(Blueprint $table) {
			$table->uuid('id')->primary();
			$table->string('urgency', 50);
			$table->string('subject');
			$table->text('description');
			$table->uuid('user_id');
			$table->integer('status')->default('0');
			$table->uuid('order_id')->nullable();
			$table->uuid('merchant_id');
			$table->string('ticket_number', 10)->unique();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('support_tickets');
	}
}