<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGameMastersTable extends Migration {

	public function up()
	{
		Schema::create('game_masters', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('game_id');
			$table->bigInteger('game_category_id')->unsigned();
			$table->bigInteger('game_provider_id')->unsigned();
			$table->bigInteger('game_type_id')->unsigned();
			$table->string('game_code', 299);
			$table->string('game_name', 299);
			$table->string('game_icon', 299)->nullable();
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('game_masters');
	}
}