<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayerBankAccountsTable extends Migration {

	public function up()
	{
		Schema::create('player_bank_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->tinyInteger('default')->default('0');
			$table->string('nickname', 299)->nullable();
			$table->bigInteger('master_bank_id')->unsigned();
			$table->string('bank_account_number', 20);
			$table->tinyInteger('verification_status')->default('0');
			$table->bigInteger('current_bank_group_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('player_bank_accounts');
	}
}