<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayersTable extends Migration {

	public function up()
	{
		Schema::create('players', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('user_id')->unsigned();
			$table->tinyInteger('process_state')->default('0');
			$table->tinyInteger('player_verified')->default('0');
			$table->bigInteger('telephone')->nullable();
			$table->string('game_session_token', 299);
			$table->bigInteger('referred_by')->nullable();
			$table->bigInteger('depost_count')->default('0');
			$table->string('game_token', 299);
			$table->datetime('gt_created_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('players');
	}
}